/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.data;

import com.teamresourceful.resourcefullib.common.utils.SaveHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import me.codexadrian.tempad.api.locations.LocationsApi;
import me.codexadrian.tempad.common.data.LocationData;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class TempadLocationHandler
extends SaveHandler {
    private static final TempadLocationHandler CLIENT_ONLY = new TempadLocationHandler();
    private final Map<UUID, Map<UUID, LocationData>> locations = new HashMap<UUID, Map<UUID, LocationData>>();
    private final Map<UUID, UUID> favorites = new HashMap<UUID, UUID>();

    public void addLocation(UUID player, LocationData location) {
        if (!this.locations.containsKey(player)) {
            this.locations.put(player, new LinkedHashMap());
        }
        this.locations.get(player).put(location.getId(), location);
    }

    public static void addLocation(class_1937 level, UUID player, LocationData location) {
        TempadLocationHandler handler = TempadLocationHandler.read(level);
        handler.addLocation(player, location);
    }

    public static void removeLocation(class_1937 level, UUID player, UUID location) {
        TempadLocationHandler handler = TempadLocationHandler.read(level);
        if (handler.locations.containsKey(player)) {
            handler.locations.get(player).remove(location);
            if (handler.favorites.containsKey(player) && handler.favorites.get(player).equals(location)) {
                handler.favorites.remove(player);
            }
        }
    }

    public static void favoriteLocation(class_1937 level, UUID player, UUID location) {
        TempadLocationHandler handler = TempadLocationHandler.read(level);
        if (handler.locations.containsKey(player)) {
            handler.favorites.put(player, location);
        }
    }

    public static void unfavoriteLocation(class_1937 level, UUID player) {
        TempadLocationHandler handler = TempadLocationHandler.read(level);
        if (handler.locations.containsKey(player)) {
            handler.favorites.remove(player);
        }
    }

    public static UUID getFavorite(class_1937 level, UUID player) {
        TempadLocationHandler handler = TempadLocationHandler.read(level);
        return handler.favorites.get(player);
    }

    public static Map<UUID, LocationData> getLocations(class_1937 level, UUID player) {
        TempadLocationHandler handler = TempadLocationHandler.read(level);
        HashMap<UUID, LocationData> orDefault = new HashMap<UUID, LocationData>(handler.locations.getOrDefault(player, Collections.emptyMap()));
        LocationsApi.gatherLocations(level, player, orDefault);
        return orDefault;
    }

    public static LocationData getLocation(class_1937 level, UUID player, UUID location) {
        return TempadLocationHandler.getLocations(level, player).get(location);
    }

    public static TempadLocationHandler read(class_1937 level) {
        return (TempadLocationHandler)TempadLocationHandler.read((class_1937)level, (SaveHandler)CLIENT_ONLY, TempadLocationHandler::new, (String)"tempad_locations");
    }

    public static boolean containsLocation(class_1937 level, UUID player, UUID location) {
        return TempadLocationHandler.getLocations(level, player).containsKey(location);
    }

    public void loadData(class_2487 tag) {
        if (tag.method_10545("Favorites")) {
            class_2487 favorites = tag.method_10562("Favorites");
            class_2487 savedLocations = tag.method_10562("SavedLocations");
            this.loadLocations(savedLocations);
            for (String playerId : favorites.method_10541()) {
                UUID player = UUID.fromString(playerId);
                UUID favorite = favorites.method_25926(playerId);
                this.favorites.put(player, favorite);
            }
        } else {
            this.loadLocations(tag);
        }
    }

    public void loadLocations(class_2487 tag) {
        for (String playerId : tag.method_10541()) {
            UUID player = UUID.fromString(playerId);
            for (class_2520 list : tag.method_10554(playerId, 10)) {
                if (!(list instanceof class_2487)) continue;
                class_2487 compound = (class_2487)list;
                this.addLocation(player, LocationData.fromTag(compound));
            }
        }
    }

    public void saveData(class_2487 tag) {
        class_2487 favorites = new class_2487();
        class_2487 savedLocations = new class_2487();
        this.locations.forEach((player, locationMap) -> {
            class_2499 playerTag = new class_2499();
            locationMap.forEach((uuid, location) -> playerTag.add((Object)location.toTag()));
            savedLocations.method_10566(player.toString(), (class_2520)playerTag);
        });
        this.favorites.forEach((player, location) -> favorites.method_25927(player.toString(), location));
        tag.method_10566("Favorites", (class_2520)favorites);
        tag.method_10566("SavedLocations", (class_2520)savedLocations);
    }

    public boolean method_79() {
        return true;
    }
}

